/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于走点硬件相关操作
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.2
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_hw_go_mod */
/* exported mc_hw_get_clock_cnt */

/* global mc_sdk_param */
/* global $ */
/* global mc_loading_wait */
/* global mc_loading_wait_remove */
/* global mc_sdk_send_memory_box_base */


/************************************************************************************************
 * 类型:
 *    构造函数
 * 功能:
 *    硬件走点系统
 * 参数:
 *    NA
 * 返回：
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.5.26
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_hw_go_mod() {
    // 定时器
    var m_mc_timer = function () { };
    // 跳点值
    var m_ui_ic_channels = 1;
    // 亮度
    var m_ui_brightness_val = 255;
    // 请求状态
    var m_b_place_state = true;
    // 单扫最长
    var m_ui_scan_len_max = -1;
    // 最长扫数
    var m_ui_scan_cnt_max = -1;
    // 单扫长度
    var m_ui_scan_len = -1;
    // 功能有效性(当没启动过定时器,中途停止定时器,功能全部丧失,需重新走点)
    var m_b_over = true;
    // 分组模式
    var m_ui_grp_mod = -1;
    // 数据线
    var m_ui_str_idx = -1;
    // 走点方式设置
    var m_b_go_point_type = false;
    // 单组描点完成
    var m_b_first_point_grp_len = false;
    // 下发逻辑点
    var m_ui_pix_idx = 0;
    // 上一个逻辑点位置
    var m_ary_last_pix_idx = [];
    // 灯串类型
    var m_ui_grp_type = 1;
    // 时钟数量
    var m_ui_clock_cnt = 1;
    // 灯串珠数
    var m_ui_led_cnt = 1;
    // 当有灯串珠数时使用计数器决定下一个跳点值跨度
    var m_ui_led_idx = 1;
    // 串行高级走点记录当前一个像素点下第几个灯坐标
    var m_ui_led_pix = 1;
    // 记录已走有效点数量
    var m_ui_valid_led_cnt = 0;
    // 记录切线状态
    var m_ary_str_show_led_state = [];
    // 数据组偏移量
    var m_ui_offset_str = 0;

    /* ************************* MC_PLACE *************************************************** */
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    像素控制请求
     * 参数:
     *    @param {Promise<String>} str_val 下发命令
     *    @param {Promise<Function>} fun_callback 回调函数
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.4.2
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_contirol_pix_switch(str_val, fun_callback) {
        if ("function" !== typeof fun_callback) {
            return;
        }
        var obj_sdk_param = new mc_sdk_param();

        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_func("PIX_SWITCH");
        obj_sdk_param.set_cmd("SET_PARAM");
        obj_sdk_param.set_param_value("mc_test_box", "(0:-1:-1:-1:-1)");
        obj_sdk_param.set_attr_val("mc_test_box", "CMD", str_val);
        $.post("/access_shell", obj_sdk_param.get_json(), function () {
            fun_callback();
            return;
        });
        return;
    }

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    重定向请求
     * 参数:
     *    @param {Promise<string>} str_val 命令字串
     *    @param {Promise<Function>} fun_callback 回调函数
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.4.2
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_contirol_redirect(str_val, fun_callback) {
        if ("function" !== typeof fun_callback) {
            return;
        }
        if ("string" !== typeof str_val || 0 >= str_val.length) {
            fun_callback();
            return;
        }
        var obj_sdk_param = new mc_sdk_param();

        obj_sdk_param.set_param_clear();
        obj_sdk_param.set_func("DSP_REDIRECT");
        obj_sdk_param.set_cmd("SET_PARAM");
        obj_sdk_param.set_param_value("mc_test_box", "(0:-1:-1:-1:-1)");
        obj_sdk_param.set_attr_val("mc_test_box", "CMD", str_val);
        $.post("/access_shell", obj_sdk_param.get_json(), function () {
            fun_callback();
            return;
        });
    }
    /* ************************* MC ********************************************************* */
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    启动定时器
     * 参数:
     *    NA
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-5-26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_start_timer() {
        m_b_over = false;
        mc_loading_wait();
        var basic_date_val = "(" + "0" + ":" + "0" + ":" + "-1" + ":" + "-1" + ":" + "0" + ")";

        mc_sdk_send_memory_box_base("BOX_NAME", "mc_test_box", basic_date_val, true, "", function () {
            mc_contirol_pix_switch("(0:-1:-1:-1)", function () {
                var str_val_redirect = "(-1:0)";

                if (-1 !== m_ui_str_idx) {
                    str_val_redirect = "(-1:1),(" + m_mc_get_str_idx() + ":0)";
                }
                mc_contirol_redirect(str_val_redirect, function () {
                    mc_loading_wait_remove();
                    clearInterval(m_mc_timer);
                    m_mc_timer = setInterval(mc_timer_util, 400);
                });
            });
        });
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    走点
     * 参数:
     *    @param {Promise<Boolean>} b_is_valid_point 当前设置点的是否为虚点
     *    @param {Promise<Boolean>} b_is_change_scan 是否换行
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-5-26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_next_pix(b_is_valid_point) {
        if (m_b_over) {
            return;
        }
        if (m_b_first_point_grp_len) {
            m_ary_last_pix_idx.push(false);
            return;
        }
        if (b_is_valid_point) {
            m_ui_valid_led_cnt++;
        }
        m_ary_last_pix_idx.push(m_ui_pix_idx);
        var str_value = "";

        if (m_b_go_point_type) {
            str_value = mc_go_point_single_wire();
        } else {
            str_value = mc_go_point_multiple_wire();
        }

        mc_contirol_pix_switch(str_value, function () { });

        var ui_point_cnt = m_ui_scan_cnt_max * m_ui_scan_len;

        if (0 === m_ui_valid_led_cnt % ui_point_cnt) {
            if (m_b_go_point_type && 1 === m_ui_grp_mod) {
                if (0 === m_ui_valid_led_cnt % (ui_point_cnt * 3)) {
                    m_b_first_point_grp_len = true;
                    clearInterval(m_mc_timer);
                    parent.mc_alert_popout("MC_LANG_FIRST_POINT_GRP");
                }
            } else {
                m_b_first_point_grp_len = true;
                clearInterval(m_mc_timer);
                parent.mc_alert_popout("MC_LANG_FIRST_POINT_GRP");
            }
        }

        if (0 === m_ui_valid_led_cnt % m_ui_scan_len) {
            if (m_b_go_point_type && 1 === m_ui_grp_mod) {
                if ( 3 === m_ui_led_pix) {
                    m_ui_pix_idx = Math.floor((m_ui_valid_led_cnt / m_ui_scan_len)) * m_ui_scan_len_max;
                }
            } else {
                m_ui_pix_idx = Math.floor((m_ui_valid_led_cnt / m_ui_scan_len)) * m_ui_scan_len_max;
            }
        }
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    走点(单线模式)
     * 参数:
     *    NA
     * 返回：
     *   @returns {String} 当前点高亮命令
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.2
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_go_point_single_wire() {
        var ui_str_val = m_mc_get_str_idx();
        var str_value = get_pix_trace_cmd(m_ui_pix_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 255, ui_str_val);

        m_ui_pix_idx++;
        return str_value;
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    走点(多线模式)
     * 参数:
     *    NA
     * 返回：
     *   @returns {String} 当前点高亮命令
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.9.2
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_go_point_multiple_wire() {
        var ui_str_val = m_mc_get_str_idx();
        var str_value = get_pix_trace_cmd(m_ui_pix_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 255, ui_str_val);


        if (1 === m_ui_grp_mod) {
            var ui_serial_add_idx = m_ui_pix_idx + m_ui_led_cnt;

            str_value += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 255, ui_str_val);
            ui_serial_add_idx += m_ui_led_cnt;
            str_value += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 255, ui_str_val);
            m_ui_pix_idx++;
            m_ui_led_idx++;
            if (m_ui_led_idx > m_ui_led_cnt) {
                m_ui_pix_idx += m_ui_led_cnt * 3 - m_ui_led_cnt;
                m_ui_led_idx = 1;
            }
        } else {
            m_ui_pix_idx++;
        }
        return str_value;
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    回撤走点
     * 参数:
     *    @param {Promise<Boolean>} b_is_valid_point 是否为有效点
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-5-26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_last_pix(b_is_valid_point) {
        if (m_b_over || 0 >= m_ary_last_pix_idx.length) {
            return;
        }
        var ui_last_point = m_ary_last_pix_idx[m_ary_last_pix_idx.length - 1];

        if (m_b_first_point_grp_len && "number" !== typeof ui_last_point) {
            m_ary_last_pix_idx.pop();

            return;
        }
        if (b_is_valid_point) {
            m_ui_valid_led_cnt--;
        }
        if ("function" !== typeof m_mc_timer) {
            clearInterval(m_mc_timer);
            m_mc_timer = setInterval(mc_timer_util, 400);
            m_b_first_point_grp_len = false;
        }

        var ui_str_val = m_mc_get_str_idx();
        var str_value = get_pix_trace_cmd(m_ui_pix_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 0, ui_str_val);

        if (1 === m_ui_grp_mod) {
            if (!m_b_go_point_type) {
                var ui_serial_add_idx = m_ui_pix_idx - m_ui_led_cnt;

                str_value += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 0, ui_str_val);
                ui_serial_add_idx -= m_ui_led_cnt;
                str_value += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, 0, ui_str_val);
                m_ui_pix_idx = ui_last_point;
                m_ary_last_pix_idx.pop();
                m_ui_led_idx--;
                if (m_ui_led_idx >= m_ui_led_cnt) {
                    m_ui_led_idx = m_ui_led_cnt;
                }
            } else {
                m_ui_pix_idx = ui_last_point;
                m_ary_last_pix_idx.pop();
                m_ui_led_pix--;
                if (1 > m_ui_led_pix) {
                    m_ui_led_pix = 3;
                    m_ui_led_idx--;
                    if (m_ui_led_idx >= m_ui_led_cnt) {
                        m_ui_led_idx = m_ui_led_cnt;
                    }
                }
            }
        } else {
            if (
                m_b_go_point_type &&
                0 !== m_ui_str_idx &&
                0 === m_ui_pix_idx
            ) {
                m_ui_str_idx--;
            }
            m_ui_pix_idx = ui_last_point;
            m_ary_last_pix_idx.pop();
        }
        mc_contirol_pix_switch(str_value, function () { });
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    重新走点
     * 参数:
     *    NA
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-5-26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_reset_timer() {
        if (m_b_over) {
            return;
        }
        clearInterval(m_mc_timer);
        // 已走有效灯珠数
        m_ui_valid_led_cnt = 0;
        // 下发逻辑点
        m_ui_pix_idx = 0;
        // 上一个逻辑点位置
        m_ary_last_pix_idx = [];
        // 灯串珠数
        m_ui_led_cnt = 1;
        // 当有灯串珠数时使用计数器决定下一个跳点值跨度
        m_ui_led_idx = 1;
        // 串行高级走点记录当前一个像素点下第几个灯坐标
        m_ui_led_pix = 1;
        m_b_first_point_grp_len = false;
        if (m_b_go_point_type) {
            if (1 !== m_ui_grp_mod) {
                m_ui_str_idx = -1;
            }
        }

        mc_loading_wait();
        mc_contirol_pix_switch("(0:-1:-1:-1)", function () {
            var str_val_redirect = "(-1:0)";

            str_val_redirect = "(-1:1),(" + m_mc_get_str_idx() + ":0)";
            mc_contirol_redirect(str_val_redirect, function () {
                mc_loading_wait_remove();
                clearInterval(m_mc_timer);
                m_mc_timer = setInterval(mc_timer_util, 400);
            });
        });
    }

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    设置当前数据线
     * 参数:
     *    @param {Promise<Number>} ui_str_idx 数据线下标(-1为全部)
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-5-26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_set_str_idx(ui_str_idx) {
        if (m_b_over) {
            return;
        }
        ui_str_idx = Number(ui_str_idx);

        if (-1 === m_ui_str_idx) {
            m_ary_str_show_led_state = [[
                m_b_first_point_grp_len,
                m_ui_pix_idx,
                m_ary_last_pix_idx.slice(0),
                m_ui_valid_led_cnt
            ]];
        } else {
            m_ary_str_show_led_state[m_ui_str_idx + 1] = [
                m_b_first_point_grp_len,
                m_ui_pix_idx,
                m_ary_last_pix_idx.slice(0),
                m_ui_valid_led_cnt
            ];
        }
        clearInterval(m_mc_timer);
        var str_val_redirect = "(-1:0)";


        if (-1 !== ui_str_idx) {
            if (m_ui_str_idx !== (ui_str_idx - 1) ) {
                m_ui_str_idx = ui_str_idx - 1;
                str_val_redirect = "(-1:1),(" + m_mc_get_str_idx() + ":0)";
            } else {
                str_val_redirect = "(-1:1),(" + m_mc_get_str_idx() + ":0)";
            }
        }
        mc_contirol_redirect(str_val_redirect, function () {
            clearInterval(m_mc_timer);

            if (-1 === ui_str_idx) {
                m_mc_timer = setInterval(mc_timer_util, 400);
                return;
            }
            if (!m_ary_str_show_led_state[ui_str_idx]) {
                m_ary_str_show_led_state[ui_str_idx] = [
                    m_ary_str_show_led_state[0][0],
                    m_ary_str_show_led_state[0][1],
                    m_ary_str_show_led_state[0][2].slice(0),
                    m_ary_str_show_led_state[0][3]
                ];
                m_b_first_point_grp_len = m_ary_str_show_led_state[0][0];
                mc_show_str_led(m_ary_str_show_led_state[0][1],function () {
                    m_mc_timer = setInterval(mc_timer_util, 400);
                });
                m_ui_pix_idx = m_ary_str_show_led_state[0][1];
                m_ary_last_pix_idx = m_ary_str_show_led_state[0][2].slice(0);
                m_ui_valid_led_cnt = m_ary_str_show_led_state[0][3];
            } else {
                m_b_first_point_grp_len = m_ary_str_show_led_state[ui_str_idx][0];
                mc_show_str_led(m_ary_str_show_led_state[ui_str_idx][1],function () {
                    m_mc_timer = setInterval(mc_timer_util, 400);
                });
                m_ui_pix_idx = m_ary_str_show_led_state[ui_str_idx][1];
                m_ary_last_pix_idx = m_ary_str_show_led_state[ui_str_idx][2].slice(0);
                m_ui_valid_led_cnt = m_ary_str_show_led_state[ui_str_idx][3];
            }
        });
    }

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    解析注册信息获取跳点值
     * 参数:
     *    @param {Promise<String>} str_info_json 注册信息
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-5-26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_set_info_msg(str_info_json) {
        var obj_sdk_param = new mc_sdk_param();

        if (!obj_sdk_param.set_json(str_info_json)) {
            return;
        }
        var ui_param_cnt = obj_sdk_param.get_param_cnt();
        var str_dispchip_name = "";

        for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
            str_dispchip_name = obj_sdk_param.get_param_name(idx_param);
            if ("ERROR_CODE" !== str_dispchip_name) {
                break;
            }
        }
        if (!str_dispchip_name || 0 >= str_dispchip_name.length) {
            return;
        }
        var ui_jump_state = Number(obj_sdk_param.get_attr_val(str_dispchip_name, "JUMP_IC"));

        if (0 !== ui_jump_state) {
            m_ui_ic_channels = Number(obj_sdk_param.get_attr_val(str_dispchip_name, "IC_CHANNELS"));
        }
    }

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    调暗当前显示灯珠,调亮当前连接线显示灯珠数
     * 参数:
     *    @param {Promise<Number>} ui_str_led_show 调亮长度
     *    @param {Promise<Function>} fn_callback 回调函数
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-12-11
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_show_str_led(ui_str_led_show,fn_callback) {
        var str_show_no_order = mc_get_led_order_by_len(m_ui_pix_idx,0);

        mc_contirol_pix_switch(str_show_no_order,function () {
            str_show_no_order = mc_get_led_order_by_len(ui_str_led_show,255);
            mc_contirol_pix_switch(str_show_no_order,fn_callback);
        });
    }
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    根据长度获取一串像素控制的命令
     * 参数:
     *    @param {Promise<Number>} ui_str_led 获取长度
     *    @param {Promise<Number>} ui_light 亮度(0,255)
     * 返回：
     *   @returns {Promise<String>} 根据长度及亮度生成的像素控制命令
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020-12-11
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_get_led_order_by_len(ui_str_led,ui_light) {
        var str_rutern = "";
        var ui_scan_idx = Math.floor(ui_str_led / m_ui_scan_len_max);

        for (var idx_scan = 0; idx_scan < ui_scan_idx; idx_scan++) {
            str_rutern += "(" + ui_light + ":" + m_mc_get_str_idx() + ":" + idx_scan + ":-1),";
        }

        for (var idx = 0; idx < (ui_str_led % m_ui_scan_len_max) + 1; idx++) {
            str_rutern += "(" + ui_light + ":" + m_mc_get_str_idx() + ":" + ui_scan_idx + ":" + (idx % m_ui_scan_len_max) + "),";
        }
        str_rutern = str_rutern.substring(0,str_rutern.length - 1);
        return str_rutern;
    }

    /* ************************ MC_TOOL ***************************************************************** */
    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取像素控制命令
     * 参数:
     *    @param {Promise<Uint>} ui_logic_idx PIX_IDX值
     *    @param {Promise<Uint>} ui_scan_len 单扫长度
     *    @param {Promise<Uint>} ui_scan_cnt 行扫数
     *    @param {Promise<Uint>} ui_pix_step 跳点值(默认为1)
     *    @param {Promise<Uint>} ui_brightness 亮度
     *    @param {Promise<Uint>} i_str_idx str位置 默认为(0)
     * 返回：
     *   @returns {Promise<string>} 硬件命令
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 张启丰
     *      时间 : 2020.4.2
     *      内容 : 所有代码
     ************************************************************************************************/
    function get_pix_trace_cmd(ui_logic_idx, ui_scan_len, ui_scan_cnt, ui_pix_step, ui_brightness, i_str_idx) {
        if ("number" !== typeof ui_logic_idx || "number" !== typeof ui_scan_len ||
            "number" !== typeof ui_scan_cnt || "number" !== typeof ui_pix_step ||
            "number" !== typeof ui_brightness || "number" !== typeof i_str_idx) {
            return "";
        }

        if (0 >= ui_scan_len || 0 >= ui_scan_cnt) {
            return "";
        }

        if (1 >= ui_pix_step) {
            ui_pix_step = 1;
        }

        if (ui_pix_step > ui_scan_len) {
            return "";
        }

        if (ui_scan_len * ui_scan_cnt <= ui_logic_idx) {
            return "";
        }

        if (0 !== ui_scan_len % ui_pix_step) {
            return "";
        }

        if (0 > ui_brightness) {
            ui_brightness = -ui_brightness;
        }

        if (255 < ui_brightness) {
            ui_brightness = 255;
        }

        if (-1 > i_str_idx) {
            i_str_idx = -1;
        }

        var ui_scan_idx = Math.floor(ui_logic_idx / ui_scan_len);


        // 根据跳点值区分多少芯片
        var ui_grp_cnt = Math.floor(ui_scan_len / ui_pix_step);

        // 获取逻辑点在单扫中的下标
        var ui_pix_idx = ui_logic_idx % ui_scan_len;
        // 获取逻辑点所在芯片下
        var ui_grp_idx = Math.floor(ui_pix_idx / ui_pix_step);

        // 获取逻辑点在芯片下的第几个引脚中
        var ui_grp_ins = ui_pix_idx % ui_pix_step;

        var ui_cmd_idx = ui_grp_ins * ui_grp_cnt + ui_grp_idx;


        return "(" + ui_brightness + ":" + i_str_idx + ":" + ui_scan_idx + ":" + ui_cmd_idx + ")";
    }

    // /* 按跳点顺序走映射到按引脚顺序走 */
    // function mc_point_get_pix_idx_by_step(ui_logic_idx, ui_scan_len, ui_pix_step) {
    //     if ("number" !== typeof ui_logic_idx || 0 > ui_logic_idx) {
    //         return false;
    //     }
    //     if ("number" !== typeof ui_scan_len || 0 >= ui_scan_len) {
    //         return false;
    //     }
    //     if ("number" !== typeof ui_pix_step || 0 >= ui_pix_step) {
    //         return false;
    //     }
    //     // 根据跳点值区分多少芯片
    //     var ui_grp_cnt = Math.floor(ui_scan_len / ui_pix_step);

    //     // 获取逻辑点在单扫中的下标
    //     var ui_pix_idx = ui_logic_idx % ui_scan_len;
    //     // 获取逻辑点所在芯片下
    //     var ui_grp_idx = Math.floor(ui_pix_idx / ui_pix_step);

    //     // 获取逻辑点在芯片下的第几个引脚中
    //     var ui_grp_ins = ui_pix_idx % ui_pix_step;

    //     var ui_cmd_idx = ui_grp_ins * ui_grp_cnt + ui_grp_idx;

    //     return ui_cmd_idx;
    // }
    /* 按引脚顺序走映射到按跳点顺序走 */
    // function mc_point_get_step_idx_by_pix(ui_cmd_idx, ui_scan_len, ui_pix_step) {
    //     if ("number" !== typeof ui_cmd_idx || 0 > ui_cmd_idx) {
    //         return false;
    //     }
    //     if ("number" !== typeof ui_pix_step || 0 >= ui_pix_step) {
    //         return false;
    //     }
    //     if ("number" !== typeof ui_scan_len || 0 >= ui_scan_len) {
    //         return false;
    //     }
    //     // 逻辑点在单扫中的第几点
    //     ui_cmd_idx %= ui_scan_len;
    //     // 根据跳点值区分多少芯片
    //     var ui_grp_cnt = Math.floor(ui_scan_len / ui_pix_step);

    //     // 获取逻辑点所在芯片下
    //     var ui_grp_idx = Math.floor(ui_cmd_idx / ui_grp_cnt);

    //     // 获取逻辑点在芯片下的第几个引脚中
    //     var ui_grp_ins = ui_cmd_idx % ui_pix_step;

    //     var ui_pix_idx = ui_grp_ins * ui_grp_cnt + ui_grp_idx;

    //     return ui_pix_idx;
    // }

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    定时器功能
     * 参数:
     *    NA
     * 返回：
     *   NA
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.5.26
     *      内容 : 所有代码
     ************************************************************************************************/
    function mc_timer_util() {
        // 请求还没成功不执行
        if (m_b_place_state) {
            // 开始请求更改状态
            m_b_place_state = false;

            m_ui_brightness_val = 0 === m_ui_brightness_val ? 255 : 0;
            var ui_str_val = m_mc_get_str_idx();
            var str_val_switch = get_pix_trace_cmd(m_ui_pix_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, m_ui_brightness_val, ui_str_val);

            if (!m_b_go_point_type) {
                if (1 === m_ui_grp_mod) {
                    var ui_serial_add_idx = m_ui_pix_idx + m_ui_led_cnt;

                    str_val_switch += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, m_ui_brightness_val, ui_str_val);
                    ui_serial_add_idx += m_ui_led_cnt;
                    str_val_switch += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, m_ui_brightness_val, ui_str_val);
                }
            }
            mc_contirol_pix_switch(str_val_switch, function () {
                m_b_place_state = true;
            });
        }
    }

    /************************************************************************************************
     * 类型:
     *    内部函数
     * 功能:
     *    获取增加了偏移后的数据线下标
     * 参数:
     *    NA
     * 返回：
     *   @returns {Promise<Number>} 偏移后的str下标
     * 修改:
     *   1. 类型 : 创建
     *      作者 : 徐烁超
     *      时间 : 2020.12.28
     *      内容 : 所有代码
     ************************************************************************************************/
    function m_mc_get_str_idx() {
        if (-1 === m_ui_str_idx) {
            return -1;
        }
        return (m_ui_offset_str + m_ui_str_idx );
    }


    /* ************************* API ******************************************************* */
    /**
     * @returns {Promise<Function>} 启动定时器
     */
    this.mc_util_start_timer = function () {
        return mc_start_timer();
    };
    /**
     * @param {Promise<Boolean>} b_is_valid_point 当前设置点的数据
     * @returns {Promise<Function>} 走下一个点
     */
    this.mc_util_next_pix = function (b_is_valid_point) {
        return mc_next_pix(b_is_valid_point);
    };
    /**
     * @param {Promise<Boolean>} b_is_valid_point 当前设置点的数据
     * @returns {Promise<Function>} 回到上一个点
     */
    this.mc_util_last_pix = function (b_is_valid_point) {
        return mc_last_pix(b_is_valid_point);
    };
    /**
     * @returns {Promise<Function>} 重新走点
     */
    this.mc_util_reset_timer = function () {
        return mc_reset_timer();
    };
    /**
     * 备注:停止走点
     */
    this.mc_util_stop_timer = function () {
        clearInterval(m_mc_timer);
        m_mc_timer = function () { };
        return;
    };
    /**
     * @param {Promise<Number>} ui_str_idx 存入走点数据线
     * @returns {Promise<Function>} 存入走点数据线
     */
    this.mc_util_set_str_idx = function (ui_str_idx) {
        return mc_set_str_idx(ui_str_idx);
    };
    /**
     * @param {Promise<String>} str_info_msg 注册信息
     * @returns {Promise<Function>} 解析注册信息获得跳点值
     */
    this.mc_util_set_info_msg = function (str_info_msg) {
        return mc_set_info_msg(str_info_msg);
    };
    /**
     * @param {Promise<Number>} ui_scan_len_max 存入单扫最长
     */
    this.mc_util_set_scan_len_max = function (ui_scan_len_max) {
        m_ui_scan_len_max = ui_scan_len_max;
        return;
    };
    /**
     * @param {Promise<Number>} ui_scan_cnt_max 存入行扫最长
     */
    this.mc_util_set_scan_cnt_max = function (ui_scan_cnt_max) {
        m_ui_scan_cnt_max = ui_scan_cnt_max;
        return;
    };
    /**
     * @param {Promise<Number>} ui_scan_len 存入单扫长度
     */
    this.mc_util_set_scan_len = function (ui_scan_len) {
        m_ui_scan_len = ui_scan_len;
        return;
    };
    /**
     * @param {Promise<Number>} ui_scan_len 存入行扫长度
     */
    this.mc_util_set_scan_cnt = function (ui_scan_len) {
        m_ui_scan_len = ui_scan_len;
        return;
    };
    /**
     * @param {Promise<Number>} ui_grp_mod 分组模式
     */
    this.mc_util_set_grp_mod = function (ui_grp_mod) {
        m_ui_grp_mod = ui_grp_mod;
        return;
    };
    /**
     * @param {Promise<Number>} ui_led_cnt 灯串珠数
     */
    this.mc_util_set_led_cnt = function (ui_led_cnt) {
        if ("number" !== typeof ui_led_cnt || isNaN(ui_led_cnt) || 0 >= ui_led_cnt) {
            ui_led_cnt = 1;
        }
        m_ui_grp_type = ui_led_cnt;
        m_ui_led_cnt = ui_led_cnt * m_ui_clock_cnt;
        return;
    };
    /**
     * @param {Promise<Number>} ui_clock_cnt 时钟数量
     */
    this.mc_util_set_clock_cnt = function (ui_clock_cnt) {
        if ("number" !== typeof ui_clock_cnt || isNaN(ui_clock_cnt) || 0 >= ui_clock_cnt) {
            ui_clock_cnt = 1;
        }
        m_ui_clock_cnt = ui_clock_cnt;
        m_ui_led_cnt = m_ui_grp_type * ui_clock_cnt;
        return;
    };
    /**
     *  备注:强制启动
     */
    this.mc_util_compulsory_start = function () {
        m_b_over = false;
        return;
    };
    /**
     * @param {Promise<Number>} b_point_type 当前走点模式(true/false):(单线走点/多线走点)
     */
    this.mc_util_set_go_point_type = function (b_point_type) {
        if (b_point_type) {
            m_b_go_point_type = true;
        } else {
            m_b_go_point_type = false;
        }
        return;
    };
    /**
     * @returns {Prmoise<String>} 当前描点命令
     */
    this.mc_util_get_point_command = function () {
        m_ui_brightness_val = 0 === m_ui_brightness_val ? 255 : 0;
        var ui_str_val = m_mc_get_str_idx();
        var str_val_switch = get_pix_trace_cmd(m_ui_pix_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, m_ui_brightness_val, ui_str_val);

        if (!m_b_go_point_type) {
            if (1 === m_ui_grp_mod) {
                var ui_serial_add_idx = m_ui_pix_idx + m_ui_led_cnt;

                str_val_switch += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, m_ui_brightness_val, ui_str_val);
                ui_serial_add_idx += m_ui_led_cnt;
                str_val_switch += "," + get_pix_trace_cmd(ui_serial_add_idx, m_ui_scan_len_max, m_ui_scan_cnt_max, m_ui_ic_channels, m_ui_brightness_val, ui_str_val);
            }
        }
        return str_val_switch;
    };
    /**
     * 修改数据线组偏移
     * @param {Promise<Number>} ui_offset 数据线组偏移 页面传入从1开始
     */
    this.mc_util_updata_offset_grp = function (ui_offset) {
        if (
            "number" !== typeof ui_offset ||
            isNaN(ui_offset) ||
            0 > ui_offset
        ) {
            return;
        }
        m_ui_offset_str = ui_offset;
        mc_set_str_idx((m_ui_str_idx + 1));
    };
}

/************************************************************************************************
* 类型:
*    内部函数
* 功能:
*    获取模组时钟数量
* 参数:
*   @param {Promise<Object>} obj_param_data mc_sdk_param实例对象
* 返回：
*   @returns {Promise<Number>} 模组中的时钟数量
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.4.2
*      内容 : 所有代码
************************************************************************************************/
function mc_hw_get_clock_cnt(obj_param_data) {
    if (
        "function" !== typeof obj_param_data.get_param_cnt ||
        "function" !== typeof obj_param_data.get_param_name ||
        "function" !== typeof obj_param_data.get_param_value
    ) {
        return 1;
    }
    var ui_param_cnt = obj_param_data.get_param_cnt();
    var ui_clock_cnt = 1;

    for (var idx_param = 0; idx_param < ui_param_cnt; idx_param++) {
        var str_param_name = obj_param_data.get_param_name(idx_param);
        var str_param_value = obj_param_data.get_param_value(str_param_name);

        if (
            -1 !== str_param_name.indexOf("MC_LANG_LABLE_SCLK") &&
            "MC_LANG_OPTION_NOT_USE" !== str_param_value
        ) {
            ui_clock_cnt++;
        }
    }
    return ui_clock_cnt;
}
